import { world, system } from '@minecraft/server'

world.beforeEvents.worldInitialize.subscribe(initEvent => {
    initEvent.blockTypeRegistry.registerCustomComponent('v360:budding_citrine', {
        onRandomTick({ block, dimension }) {
            const { x, y, z } = block.location
            const growCrystal = Math.random()
            if (growCrystal <= 1 / 24) {
                block.dimension.runCommand(`fill ${x} ${y - 1} ${z} ${x} ${y - 1} ${z} v360:small_citrine_bud ["minecraft:block_face" = "down"] replace air`)
            }
            else if (growCrystal <= 2 / 24) {
                block.dimension.runCommand(`fill ${x} ${y - 1} ${z} ${x} ${y - 1} ${z} v360:medium_citrine_bud ["minecraft:block_face" = "down"] replace v360:small_citrine_bud ["minecraft:block_face" = "down"]`)
            }
            else if (growCrystal <= 3 / 24) {
                block.dimension.runCommand(`fill ${x} ${y - 1} ${z} ${x} ${y - 1} ${z} v360:large_citrine_bud ["minecraft:block_face" = "down"] replace v360:medium_citrine_bud ["minecraft:block_face" = "down"]`)
            }
            else if (growCrystal <= 4 / 24) {
                block.dimension.runCommand(`fill ${x} ${y - 1} ${z} ${x} ${y - 1} ${z} v360:citrine_cluster ["minecraft:block_face" = "down"] replace v360:large_citrine_bud ["minecraft:block_face" = "down"]`)
            }
            else if (growCrystal <= 5 / 24) {
                block.dimension.runCommand(`fill ${x} ${y + 1} ${z} ${x} ${y + 1} ${z} v360:small_citrine_bud ["minecraft:block_face" = "up"] replace air`)
            }
            else if (growCrystal <= 6 / 24) {
                block.dimension.runCommand(`fill ${x} ${y + 1} ${z} ${x} ${y + 1} ${z} v360:medium_citrine_bud ["minecraft:block_face" = "up"] replace v360:small_citrine_bud ["minecraft:block_face" = "up"]`)
            }
            else if (growCrystal <= 7 / 24) {
                block.dimension.runCommand(`fill ${x} ${y + 1} ${z} ${x} ${y + 1} ${z} v360:large_citrine_bud ["minecraft:block_face" = "up"] replace v360:medium_citrine_bud ["minecraft:block_face" = "up"]`)
            }
            else if (growCrystal <= 8 / 24) {
                block.dimension.runCommand(`fill ${x} ${y + 1} ${z} ${x} ${y + 1} ${z} v360:citrine_cluster ["minecraft:block_face" = "up"] replace v360:large_citrine_bud ["minecraft:block_face" = "up"]`)
            }
            else if (growCrystal <= 9 / 24) {
                block.dimension.runCommand(`fill ${x} ${y} ${z - 1} ${x} ${y} ${z - 1} v360:small_citrine_bud ["minecraft:block_face" = "north"] replace air`)
            }
            else if (growCrystal <= 10 / 24) {
                block.dimension.runCommand(`fill ${x} ${y} ${z - 1} ${x} ${y} ${z - 1} v360:medium_citrine_bud ["minecraft:block_face" = "north"] replace v360:small_citrine_bud ["minecraft:block_face" = "north"]`)
            }
            else if (growCrystal <= 11 / 24) {
                block.dimension.runCommand(`fill ${x} ${y} ${z - 1} ${x} ${y} ${z - 1} v360:large_citrine_bud ["minecraft:block_face" = "north"] replace v360:medium_citrine_bud ["minecraft:block_face" = "north"]`)
            }
            else if (growCrystal <= 12 / 24) {
                block.dimension.runCommand(`fill ${x} ${y} ${z - 1} ${x} ${y} ${z - 1} v360:citrine_cluster ["minecraft:block_face" = "north"] replace v360:large_citrine_bud ["minecraft:block_face" = "north"]`)
            }
            else if (growCrystal <= 13 / 24) {
                block.dimension.runCommand(`fill ${x} ${y} ${z + 1} ${x} ${y} ${z + 1} v360:small_citrine_bud ["minecraft:block_face" = "south"] replace air`)
            }
            else if (growCrystal <= 14 / 24) {
                block.dimension.runCommand(`fill ${x} ${y} ${z + 1} ${x} ${y} ${z + 1} v360:medium_citrine_bud ["minecraft:block_face" = "south"] replace v360:small_citrine_bud ["minecraft:block_face" = "south"]`)
            }
            else if (growCrystal <= 15 / 24) {
                block.dimension.runCommand(`fill ${x} ${y} ${z + 1} ${x} ${y} ${z + 1} v360:large_citrine_bud ["minecraft:block_face" = "south"] replace v360:medium_citrine_bud ["minecraft:block_face" = "south"]`)
            }
            else if (growCrystal <= 16 / 24) {
                block.dimension.runCommand(`fill ${x} ${y} ${z + 1} ${x} ${y} ${z + 1} v360:citrine_cluster ["minecraft:block_face" = "south"] replace v360:large_citrine_bud ["minecraft:block_face" = "south"]`)
            }
            else if (growCrystal <= 17 / 24) {
                block.dimension.runCommand(`fill ${x - 1} ${y} ${z} ${x - 1} ${y} ${z} v360:small_citrine_bud ["minecraft:block_face" = "west"] replace air`)
            }
            else if (growCrystal <= 18 / 24) {
                block.dimension.runCommand(`fill ${x - 1} ${y} ${z} ${x - 1} ${y} ${z} v360:medium_citrine_bud ["minecraft:block_face" = "west"] replace v360:small_citrine_bud ["minecraft:block_face" = "west"]`)
            }
            else if (growCrystal <= 19 / 24) {
                block.dimension.runCommand(`fill ${x - 1} ${y} ${z} ${x - 1} ${y} ${z} v360:large_citrine_bud ["minecraft:block_face" = "west"] replace v360:medium_citrine_bud ["minecraft:block_face" = "west"]`)
            }
            else if (growCrystal <= 20 / 24) {
                block.dimension.runCommand(`fill ${x - 1} ${y} ${z} ${x - 1} ${y} ${z} v360:citrine_cluster ["minecraft:block_face" = "west"] replace v360:large_citrine_bud ["minecraft:block_face" = "west"]`)
            }
            else if (growCrystal <= 21 / 24) {
                block.dimension.runCommand(`fill ${x + 1} ${y} ${z} ${x + 1} ${y} ${z} v360:small_citrine_bud ["minecraft:block_face" = "east"] replace air`)
            }
            else if (growCrystal <= 22 / 24) {
                block.dimension.runCommand(`fill ${x + 1} ${y} ${z} ${x + 1} ${y} ${z} v360:medium_citrine_bud ["minecraft:block_face" = "east"] replace v360:small_citrine_bud ["minecraft:block_face" = "east"]`)
            }
            else if (growCrystal <= 23 / 24) {
                block.dimension.runCommand(`fill ${x + 1} ${y} ${z} ${x + 1} ${y} ${z} v360:large_citrine_bud ["minecraft:block_face" = "east"] replace v360:medium_citrine_bud ["minecraft:block_face" = "east"]`)
            }
            else {
                block.dimension.runCommand(`fill ${x + 1} ${y} ${z} ${x + 1} ${y} ${z} v360:citrine_cluster ["minecraft:block_face" = "east"] replace v360:large_citrine_bud ["minecraft:block_face" = "east"]`)
            }
        },
        onPlayerDestroy({ block, dimension, player }) {
            const selectedItem = player.getComponent('equippable').getEquipment('Mainhand')
            const itemCitrine = dimension.getEntities({ type: 'minecraft:item', name: 'Budding Citrine', closest: 1 })
            if (player.getGameMode() !== 'creative' && selectedItem && selectedItem.getComponent('enchantable').getEnchantment('silk_touch')) {
                itemCitrine[0].kill()
            }
        }
    })
})